function EC_MO_write_rFiles(Mfile,mireg,ext)
% Inf B0 images - Source images are collected automatically: "n(1:length(n)-13)". 
% Note: This may faile, if the notation is not appropriate. 
% This part write the registered volumes
% S. Mohammadi (31/10/2011)

spm_defaults


%%%DEFAULTS
default_Vol = 15; % recommended
% default_Vol = 3; % nearest neighbour interpolation

if(~exist('Mfile'))
    % Get Source Images
    Mfile      = char(cfg_getfile(Inf,'MAT',['Source matfiles']));
end
for j=1:size(Mfile,1),
    load(deblank(Mfile(j,:)));
    params(j,:)=xk;
end
% select the image to write
VOLtmp  = zeros(mireg.VG.dim(1),mireg.VG.dim(2),mireg.VG.dim(3),size(Mfile,1));

for k = 1:size(Mfile,1),
    [mp,mn,me] = fileparts(Mfile(k,:));
    PW      = char(cfg_getfile('FPlist',mp,['^' mn(8:end) ext]));
    VW      = spm_vol(PW);
    Ai = spm_read_vols(VW);
    for z=1:VW.dim(3),
        zmm     = (z*VW.mat(3,3)+VW.mat(3,4));
        zmin    = (1*VW.mat(3,3)+VW.mat(3,4));
        zmax    = (VW.dim(3)*VW.mat(3,3)+VW.mat(3,4));
        M       = spm_matrix_mod(params(k,:));
        M1      = inv(VW.mat) * M * VW.mat;
        [x1,x2,x3] = ndgrid(1:VW.dim(1),1:VW.dim(2),z);

        [x1, x2, x3] = matr_mult (M1, x1, x2, x3);

        VOLtmp(:,:,z,k) = spm_sample_vol(Ai,x1,x2,x3,default_Vol);   

        prefix = 'r';
        VGname  = [mp filesep mn(8:end) ext];
        mireg.VG.fname = VGname;
        write_data(VOLtmp(:,:,:,k),mireg.VG,prefix);      
    end
    disp(['Resampling Volume ' num2str(k)]);
    clear Ai;
end
disp('All diffusion weighted images resliced')


%-----------------------------------------------------------%
function [y1, y2, y3] = matr_mult (A, x1, x2, x3)

y1=A(1,1)*x1+A(1,2)*x2+A(1,3)*x3+A(1,4);
y2=A(2,1)*x1+A(2,2)*x2+A(2,3)*x3+A(2,4);
y3=A(3,1)*x1+A(3,2)*x2+A(3,3)*x3+A(3,4);

%- write data -------------------
function write_data(vol1,V,prefix,ending)
[pth,fname,ext] = fileparts(V.fname);
if(~exist('ending'))
    V.fname=[pth filesep prefix fname ext];
else
    V.fname=[pth filesep prefix fname ending ext];
end
spm_write_vol(V, vol1);

