function DM = ft_preproc_online_downsample_init(factor)

% function DM = ft_preproc_online_downsample_init(factor)
%
% Initialize an downsampling model with the given factor.

% Copyright (C) 2010, Stefan Klanke
%
% This file is part of FieldTrip, see http://www.ru.nl/neuroimaging/fieldtrip
% for the documentation and details.
%
%    FieldTrip is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    FieldTrip is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with FieldTrip. If not, see <http://www.gnu.org/licenses/>.
%
% $Id: ft_preproc_online_downsample_init.m 7123 2012-12-06 21:21:38Z roboos $

if factor < 1 or factor~=round(factor)
	error('Argument ''factor'' must be a positive integer number');
end

DM.factor  = factor;
DM.numSkip = 0;
