% matlabbatch - A batch system for MATLAB
% =======================================
%
% This batch system provides a framework to connect tools from different
% toolboxes/applications without the need to learn each applications
% programming interface. The inputs to each tool have to be described in
% a configuration .m file. 
% All input and tool configuration is organised in a tree-like object
% structure. The data entered will be kept in the .val{1} field of the
% object. The values of pre-configured choices can be retrieved as a cell
% list of items in a .values field.
% Before running a tool, its input are collected from the tree
% by a method called "harvest". The following objects are available:
%
% * cfg_const - Constant value
%
%   The resulting data structure simply contains the contents of
%   val{1}.
%
%
% * cfg_menu  - Data entry by menu
%
%   The resulting data structure simply contains the contents of
%   val{1}, which corresponds to the element of values selected
%   by the user.
%
%
% * cfg_entry - Entry by typing
%
%   The resulting data structure simply contains the contents of
%   val{1}, which is what the user specified.
%
%
% * cfg_files - Entry by file selection
%
%   The resulting data structure simply contains a cell array
%   of filenames (from val{1} ).
%
%
% * cfg_branch - Branch of the tree structure
%
%   The resulting data structure is a struct, with fieldnames according
%   to the 'tag's of the child nodes (i.e. .val items).
%
%
% * cfg_choice - A choice of ways of changing the tree structure
%
%   The resulting data structure is a struct with a single field.  The
%   name of the field is given by the 'tag' of the specified value.
%
%
% * cfg_repeat - Repeated kids in the tree structure
%
%   If the number of elements in the 'values' field is greater than
%   one, then the resulting data structure is a cell array.  Each
%   element of the cell array is a struct with a single field, where
%   the name of the field is given by the 'tag' of the child node.
%
%   If the 'values' field only contains one element, which is a 'branch',
%   then the data structure is a struct array (in which case the 'tag'
%   of the current node can be ignored).
%
%   If the 'values' field only contains one element, which is not a branch,
%   then the data structure is a cell array, where each element is the value
%   of the child node ((in which case the 'tag' of the current node can be
%   ignored).
%
%   The 'num' field is a 2-vector [min max] which limits the occurence of
%   the repeated substructure(s). This can be used to check inputs whether
%   there is at least one repeated entry.
%
% More details about the fields present in each object and the harvest
% behaviour can be found in object/method specific help.
%
% The code of this batch system is organised as follows:
% * configuration item classes
% * cfg_util.m   - a utility to manage configuration trees, create and run
%                  jobs
% * cfg_ui.m     - a simple user interface to cfg_util
% * cfg_mlbatch_cfg.m - run-time configuration of cfg_util. It adds
%                  cfg_basicio to the MATLAB path and adds the
%                  configuration in cfg_basicio to cfg_util.
% * cfg_cfg/     - a configuration definition, that allows cfg_ui to be
%                  used to generate code for cfg_ui user interfaces.
% * cfg_basicio/ - configuration definition for tools that provide basic
%                  file and variable input/output routines.
% * cfg_example/ - a small example application to demonstrate the basic
%                  principles of this batch system.
%
% This code is part of a batch job configuration system for MATLAB. See 
%      help matlabbatch
% for a general overview.
%_______________________________________________________________________
% Copyright (C) 2007 Freiburg Brain Imaging

% Volkmar Glauche
% $Id: matlabbatch.man 1467 2008-04-22 07:46:05Z volkmar $
